## Prerequisites

- Requirements: thunar, gtk3, and cryfs, encfs or fscrypt.
- For FSCrypt on Ext4, encrypt feature flag must be enabled: `tune2fs -O encrypt /dev/device`.
- Download [Thunar-Encryption-Plugin source archives and packages](https://fox-echo.info/thunar-encryption-plugin/res).


## Build and install

This software is programmed in C language and uses the CMake build system.

From the project root directory, run:

```sh
mkdir build
cd build
cmake .. [-DCMAKE_INSTALL_PREFIX=/usr] [-DCMAKE_INSTALL_LIBDIR=lib64]
make
sudo make install [DESTDIR=$(pwd)/pack]
```

To uninstall, run: `sudo make uninstall`


## Translate

To translate this software into your language, from the project's `po` directory:

1. Setup env:

```sh
LNG=$(echo $LANG | cut -f1 -d_)                         #or LNG="es", LNG="it", ...
```

2. Run: `msginit` (or `msginit -l es_ES.UTF-8` for example).
3. Edit the `$LNG.po` file.
4. Test the translation: `msgfmt -o /usr/share/locale/$LNG/LC_MESSAGES/thunar-encryption-plugin.mo $LNG.po`.
5. Send me your translation.

